/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DashModifier
extends Modifier
implements ConditionalStatModifierHook {
    public float getbonus(float speed, int level, int status) {
        return speed * (float)level * (float)status;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        if (context.getLivingTarget() != null) {
            Player player = context.getPlayerAttacker();
            float speed = player.m_6113_();
            if (player != null) {
                float bonus = this.getbonus(speed, level, 20);
                return damage * (1.0f + bonus);
            }
            return damage;
        }
        return damage;
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        float speed = player.m_6113_();
        if (player != null) {
            float bonus = this.getbonus(speed, level, 20);
            event.setNewSpeed(event.getNewSpeed() * (1.0f + bonus));
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        int level = modifier.getLevel();
        float speed = living.m_6113_();
        if (living != null && living.m_20142_()) {
            float bonus = this.getbonus(speed, level, 20);
            if (stat == ToolStats.VELOCITY) {
                return baseValue * (1.0f + bonus);
            }
            return baseValue;
        }
        return baseValue;
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        if (player != null) {
            float speed = player.m_6113_();
            float bonus = this.getbonus(speed, level, 20);
            boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
            if (player != null) {
                if (harvest) {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.dash.attack_damage"), bonus, tooltip);
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.dash.draw_speed"), bonus, tooltip);
                } else {
                    this.addPercentTooltip((Component)new TranslatableComponent("modifier.tinkerscalibration.dash.draw_speed"), bonus, tooltip);
                }
            }
        }
    }
}

